% fcst_Omega_shares_mean_V1.m
% 
% Forecast Omega shares using cosine transformations ... 
%       Linear trend + I(1) model
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
function fcst_Omega_shares_mean_V1

% -- File Directories -- %
% datadir = 'Data/DataReplication/DataFinal/'; 
% outdir = 'Tables/';
% figdir = 'Figures/';
matdir = 'Output/';

% -- Load Data and Setup -- %
omega = [];             % this prevents an error from confusion about omega
load_data;
% n_draws = 5000;
period_lower = 20;       % Shortest Period 
T_is = size(theta,1);
q_is = floor(2*T/period_lower);
per_q_is = 2*T/q_is;
fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
fprintf('Number of Shortest Periods: %5.1f \n',per_q_is);

h_os = T_is;
Share_is_mat = NaN(5,5,T_is+h_os);
Shareproj_os_mean_mat = NaN(5,5,T_is+h_os); 
Shareproj_is_mat = NaN(5,5,T_is+h_os); 
Share_os_trend_mat =  NaN(5,5,T_is+h_os);
Share_os_trend_only_mat = NaN(5,5,T+h_os); 

for i_col = 1:5
    Share_mat = squeeze(omega(:,i_col,:))';
    T_is = size(Share_mat,1);
    % nS = size(Share_mat,2);
    i_base = 5;  % Base sector for logit transformation

    % Compute logit transformation
    X_is = logit_s_to_x(Share_mat,i_base);
    Y = X_is(:,1:end ~= i_base);

    % Get some results from I_1 model
    I_1 = 1;
    I_trend = 1; % Include linear trend in the projections
    h_os = T_is;
    [Yproj_is, Yproj_os_mean, trend_os_only] = fcst_y_trend_mean(Y,q_is,h_os,I_1,I_trend);
    T_os = size(Yproj_is,1);
    % Get LF estimates of Shares
    Share_is = [Share_mat;NaN(T_os-T_is,size(Share_mat,2))];
    Shareproj_is = logit_y_to_s(Yproj_is,i_base);
    Shareproj_os_mean = logit_y_to_s(Yproj_os_mean,i_base);
    Share_os_trend_only = logit_y_to_s(trend_os_only,i_base);
    % Add the trend-only Forecast
    Share_os_trend = NaN(size(Shareproj_os_mean));
    Share_os_trend(T_is+1:end,:) = Shareproj_os_mean(T_is,:)+Share_os_trend_only(T_is+1:end,:)-Share_os_trend_only(T_is,:);
    
    Share_is_mat(:,i_col,:) = Share_is';
    Shareproj_os_mean_mat(:,i_col,:) = Shareproj_os_mean';
    Shareproj_is_mat(:,i_col,:) = Shareproj_is'; 
    Share_os_trend_mat(:,i_col,:) = Share_os_trend';
    Share_os_trend_only_mat(:,i_col,:) = Share_os_trend_only'; 
end

% Save the results
save_variables = {'Share_is_mat','Shareproj_os_mean_mat','Shareproj_is_mat','Share_os_trend_mat','Share_os_trend_only_mat'};
save([matdir 'fcst_Omega_shares_V1_' num2str(q_is) '.mat'],save_variables{:});
